/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.ControllerThread;
import java.net.Socket;
import java.util.Vector;

public class ControllerThreadPool {
    private static final int ADD_REQUEST = 1;
    private static final int GET_REQUEST = 2;
    private static int maxThreads;
    private static ControllerThread[] queue;
    private static Vector requestQueue;
    private static boolean initialized;

    public static synchronized void create(int n, int n2) {
        int n3;
        if (initialized) {
            return;
        }
        initialized = true;
        maxThreads = n2;
        requestQueue = new Vector();
        queue = new ControllerThread[maxThreads];
        for (n3 = 0; n3 < n; ++n3) {
            ControllerThreadPool.queue[n3] = new ControllerThread();
        }
        for (n3 = n; n3 < maxThreads; ++n3) {
            ControllerThreadPool.queue[n3] = null;
        }
    }

    private static synchronized void requestQueueOp(int n, ControllerThread controllerThread, Socket socket) {
        if (1 == n) {
            for (int i = 0; i < maxThreads; ++i) {
                if (null != queue[i]) {
                    if (!queue[i].isAvailable()) continue;
                    queue[i].assignRequest(socket, true);
                    return;
                }
                ControllerThreadPool.queue[i] = new ControllerThread(socket, false);
                queue[i].start();
                return;
            }
            requestQueue.add(socket);
        } else if (2 == n) {
            if (requestQueue.isEmpty()) {
                controllerThread.setAvailable();
            } else {
                socket = (Socket)requestQueue.remove(0);
                controllerThread.assignRequest(socket, false);
            }
        }
    }

    public static void newRequest(Socket socket) {
        ControllerThreadPool.requestQueueOp(1, null, socket);
    }

    public static void completedRequest(ControllerThread controllerThread) {
        ControllerThreadPool.requestQueueOp(2, controllerThread, null);
    }

    static {
        initialized = false;
    }
}

